
clear;clc;

% Grid
 n=600; 
  xl=200; 
   dx=xl/n;
    x=0:dx:xl;

   
% Initial conditons
 ht=10; 
 hb=2;  
 
U=zeros(3,n+1);
u=zeros(1,n+1);
c=zeros(1,n+1);

U(1,1:n/2)=ht;U(1,n/2+1:n+1)=hb;
U(2,1:n/2)=ht.*u(1:n/2);U(2,n/2+1:n+1)=hb.*u(n/2+1:n+1);
U(3,1:n/2)=ht.*c(1:n/2);U(3,n/2+1:n+1)=hb.*c(n/2+1:n+1);

z=zeros(1,n+1);
 
 

% Roe


t=0;nmb=840;g=9.8;

% Time
T=zeros(1,nmb);

U1=U;
U2=U;
z11=z;
z12=z;


for k=1:nmb 
    
    h1=U1(1,:);
    u1=U1(2,:)./U1(1,:);
    c1=U1(3,:)./U1(1,:);
 
    cm=sqrt(g*h1);
    
    dt=time(U1,cm,n,dx);
    t=t+dt;
    T(k)=t;
    
    
    
    U1=fxx(n,U1,dx,dt);
    U2=fxx(n,U2,dx,dt);
    
    z11=z1(n,U1,z11,dt);
    z12=z1(n,U2,z12,dt);
    
    s1=source(n,U1,z11,dx);
    s2=source1(n,U2,z12,dx);

    U1=cpu(U1,dt,n,s1);
    U2=cpu(U2,dt,n,s2);

      
    z11=z1(n,U1,z11,dt);
    z12=z1(n,U2,z12,dt);
    
    A=U1(3,:)./U1(1,:);
    B=U2(3,:)./U2(1,:);
    
    for i=1:n+1  
     if A(i)<0;
      U1(3,i)=0;
     end
    end
    
     for i=1:n+1  
     if B(i)<0;
      U2(3,i)=0;
     end
    end
    
    
    subplot(2,2,[1 3])
    plot(x,U1(1,:),'--',x,U2(1,:),'-',x,z11,'--',x,z12,'-');
    subplot(2,2,2)
    plot(x,U1(3,:)./U1(1,:),'--',x,U2(3,:)./U2(1,:),'-');
    subplot(2,2,4)
    plot(x,U1(2,:)./U1(1,:),'--',x,U2(2,:)./U2(1,:),'-');
    drawnow
    
    
end




